package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannerAssetUpdateApiDomainStatOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannerLogoDeleteFromModReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannerLogoInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.SetBannerLogoStatusModerateOp;

@Component
public class BannerLogoOperations extends BaseResponseOperationsChain<BannerAssetModerationResponse> {

    private static final List<Class<? extends ModerationResponseProcessingOp<BannerAssetModerationResponse>>>
            BANNER_LOGO_OPERATIONS = List.of(
            SetBannerLogoStatusModerateOp.class,
            BannerLogoDeleteFromModReasonsOp.class,
            BannerLogoInsertOrUpdateModerationReasonsOp.class,
            BannerAssetUpdateApiDomainStatOp.class
    );

    @Autowired
    public BannerLogoOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerAssetModerationResponse>>> getOperationClasses() {
        return BANNER_LOGO_OPERATIONS;
    }
}
