package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations

import org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE
import org.springframework.context.ApplicationContext
import org.springframework.context.annotation.Scope
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationResponse
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannerAssetUpdateApiDomainStatOp
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.SetBannerMulticardStatusModerateAndFlagsOp
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.common.BaseBannerDeleteFromModReasonsOp
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.common.BaseBannerInsertOrUpdateModerationReasonsOp
import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonObjectType
import ru.yandex.direct.core.entity.moderationreason.repository.ModerationReasonRepository
import ru.yandex.direct.dbschema.ppc.enums.ModReasonsType

@Component
@Scope(SCOPE_PROTOTYPE)
class BannerMulticardDeleteFromModReasonsOp(
    moderationReasonRepository: ModerationReasonRepository,
) : BaseBannerDeleteFromModReasonsOp<BannerAssetModerationResponse>(
    moderationReasonRepository,
    ModReasonsType.banner_multicard,
)

@Component
@Scope(SCOPE_PROTOTYPE)
class BannerMulticardInsertOrUpdateModerationReasonOp(
    moderationReasonRepository: ModerationReasonRepository,
) : BaseBannerInsertOrUpdateModerationReasonsOp<BannerAssetModerationResponse>(
    moderationReasonRepository,
    ModerationReasonObjectType.BANNER_MULTICARD,
    false,
)

@Component
class BannerMulticardOperations(applicationContext: ApplicationContext) :
    BaseResponseOperationsChain<BannerAssetModerationResponse>(applicationContext) {

    override fun getOperationClasses(): List<Class<out ModerationResponseProcessingOp<BannerAssetModerationResponse>>> =
        listOf(
            SetBannerMulticardStatusModerateAndFlagsOp::class.java,
            BannerMulticardDeleteFromModReasonsOp::class.java,
            BannerMulticardInsertOrUpdateModerationReasonOp::class.java,
            BannerAssetUpdateApiDomainStatOp::class.java,
        )
}
