package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.context.ApplicationContext;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannersUpdateApiDomainStatOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.CatalogiaIdsSavingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.DeleteCreativeReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.ResetStatusBsSyncedOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.UpdateBannerDynDisclaimer;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.UpdateBannerFlagsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.UpdateBannerLanguageOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.UpdateMinusRegionsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.UpdateStatusModerateAndPostModerateOp;

public abstract class BannerOperations extends BaseResponseOperationsChain<BannerModerationResponse> {

    static final List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> BANNERS_OPERATIONS =
            List.of(
                    DeleteCreativeReasonsOp.class,
                    UpdateBannerFlagsOp.class,
                    UpdateBannerLanguageOp.class,
                    UpdateMinusRegionsOp.class,
                    UpdateStatusModerateAndPostModerateOp.class,
                    ResetStatusBsSyncedOp.class,
                    CatalogiaIdsSavingOp.class,
                    BannersUpdateApiDomainStatOp.class,
                    UpdateBannerDynDisclaimer.class);

    BannerOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }
}
