package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.bannerstorage.BannerstorageCreativeModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.bannerstorage.BannerstorageCreativeDeleteFromModReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.bannerstorage.BannerstorageCreativeInsertOrUpdateModReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.bannerstorage.ResetBsSyncOnPerformanceBannersOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.bannerstorage.SetBannerstorageCreativeStatusModerateOp;

@Component
public class BannerstorageCreativesOperations extends
        BaseResponseOperationsChain<BannerstorageCreativeModerationResponse> {

    private static final List<Class<? extends ModerationResponseProcessingOp<BannerstorageCreativeModerationResponse>>>
            BANNER_LOGO_OPERATIONS =
            List.of(
                    BannerstorageCreativeDeleteFromModReasonsOp.class,
                    BannerstorageCreativeInsertOrUpdateModReasonsOp.class,
                    SetBannerstorageCreativeStatusModerateOp.class,
                    ResetBsSyncOnPerformanceBannersOp.class
            );

    @Autowired
    public BannerstorageCreativesOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerstorageCreativeModerationResponse>>> getOperationClasses() {
        return BANNER_LOGO_OPERATIONS;
    }
}
