package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.CalloutInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.CalloutLazyBsResyncBannersOperation;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.SetCalloutStatusModerateOp;

import static ru.yandex.direct.core.entity.moderation.ModerationOperationMode.RESTRICTED;

@Component
public class CalloutOperations extends BaseResponseOperationsChain<CalloutModerationResponse> {

    private static final List<Class<? extends ModerationResponseProcessingOp<CalloutModerationResponse>>>
            CALLOUT_OPERATIONS = List.of(
            SetCalloutStatusModerateOp.class,
            CalloutInsertOrUpdateModerationReasonsOp.class,
            CalloutLazyBsResyncBannersOperation.class
    );

    private final ModerationOperationModeProvider moderationOperationModeProvider;

    @Autowired
    public CalloutOperations(ApplicationContext applicationContext,
                             ModerationOperationModeProvider moderationOperationModeProvider) {
        super(applicationContext);
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<CalloutModerationResponse>>> getOperationClasses() {
        return CALLOUT_OPERATIONS;
    }

    @Override
    protected boolean restrictedModeEnabled(CalloutModerationResponse response) {
        return moderationOperationModeProvider.getMode(ModerationObjectType.CALLOUT).equals(RESTRICTED);
    }
}
