package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannersInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.UpdateBannerPerformanceStatusModerateOp;

import static ru.yandex.direct.core.entity.moderation.ModerationOperationMode.RESTRICTED;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.CANVAS;

@ParametersAreNonnullByDefault
@Component
public class CanvasBannerOperations extends BannerOperations {

    private static final List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> DEFAULT_OPERATIONS =
            ImmutableList.<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>>builder()
                    .addAll(BANNERS_OPERATIONS)
                    .add(BannersInsertOrUpdateModerationReasonsOp.class)
                    .add(UpdateBannerPerformanceStatusModerateOp.class)
                    .build();

    private final ModerationOperationModeProvider moderationOperationModeProvider;

    @Autowired
    protected CanvasBannerOperations(ApplicationContext applicationContext,
                                     ModerationOperationModeProvider moderationOperationModeProvider) {
        super(applicationContext);
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    protected boolean restrictedModeEnabled(BannerModerationResponse response) {
        return RESTRICTED.equals(moderationOperationModeProvider.getMode(CANVAS));
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> getOperationClasses() {
        return DEFAULT_OPERATIONS;
    }
}
