package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import com.google.common.collect.ImmutableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;

import static ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations.BannerOperationsConstants.CPM_YNDX_FRONTPAGE_OPERATIONS;

@Component
public class CpmYndxFrontpageOperations extends BannerOperations {
    private static final List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> CPM_FRONTPAGE_OPERATIONS =
            ImmutableList.<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>>builder()
                    .addAll(BANNERS_OPERATIONS)
                    .addAll(CPM_YNDX_FRONTPAGE_OPERATIONS)
                    .build();

    @Autowired
    protected CpmYndxFrontpageOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> getOperationClasses() {
        return CPM_FRONTPAGE_OPERATIONS;
    }
}
