package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import com.google.common.collect.ImmutableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannersInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.UpdateBannerPerformanceStatusModerateOp;

@Component
public class DefaultBannerOperations extends BannerOperations {
    private static final List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> DEFAULT_OPERATIONS =
            ImmutableList.<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>>builder()
                    .addAll(BANNERS_OPERATIONS)
                    .add(BannersInsertOrUpdateModerationReasonsOp.class)
                    .add(UpdateBannerPerformanceStatusModerateOp.class)
                    .build();

    @Autowired
    protected DefaultBannerOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> getOperationClasses() {
        return DEFAULT_OPERATIONS;
    }
}
