package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.displayhrefs.DisplayHrefsModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.displayhrefs.DisplayhrefsInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.displayhrefs.DisplayhrefsUpdateApiDomainStatOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.displayhrefs.SetDisplayhrefsStatusModerateOp;

@Component
public class DisplayhrefsOperations extends BaseResponseOperationsChain<DisplayHrefsModerationResponse> {

    private static final List<Class<? extends ModerationResponseProcessingOp<DisplayHrefsModerationResponse>>> DISPLAYHREFS_OPERATIONS =
            List.of(
                    SetDisplayhrefsStatusModerateOp.class,
                    DisplayhrefsInsertOrUpdateModerationReasonsOp.class,
                    DisplayhrefsUpdateApiDomainStatOp.class
            );

    @Autowired
    public DisplayhrefsOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<DisplayHrefsModerationResponse>>> getOperationClasses() {
        return DISPLAYHREFS_OPERATIONS;
    }
}
