package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.image.ImageModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.image.ImageDeleteFromModReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.image.ImageInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.image.ImageUpdateApiDomainStatOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.image.SetImageStatusModerateOp;

@Component
public class ImageOperations extends BaseResponseOperationsChain<ImageModerationResponse> {

    private static final List<Class<? extends ModerationResponseProcessingOp<ImageModerationResponse>>> IMAGE_OPERATIONS =
            List.of(
                    SetImageStatusModerateOp.class,
                    ImageDeleteFromModReasonsOp.class,
                    ImageInsertOrUpdateModerationReasonsOp.class,
                    ImageUpdateApiDomainStatOp.class
            );

    @Autowired
    public ImageOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<ImageModerationResponse>>> getOperationClasses() {
        return IMAGE_OPERATIONS;
    }
}
