package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.InternalBannersInsertOrUpdateModerationReasonsOp;

@Component
@ParametersAreNonnullByDefault
public class InternalBannerOperations extends BannerOperations {
    private static final List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> INTERNAL_OPERATIONS =
            ImmutableList.<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>>builder()
                    .addAll(BANNERS_OPERATIONS)
                    .add(InternalBannersInsertOrUpdateModerationReasonsOp.class)
                    .build();

    @Autowired
    InternalBannerOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> getOperationClasses() {
        return INTERNAL_OPERATIONS;
    }
}
