package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.mobilecontenticon.MobileContentIconInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.mobilecontenticon.SetMobileContentIconStatusModerateAndBsSyncedOp;

import static ru.yandex.direct.core.entity.moderation.ModerationOperationMode.RESTRICTED;

@Component
public class MobileContentIconOperations extends BaseResponseOperationsChain<MobileContentIconModerationResponse>  {
    private static final List<Class<? extends ModerationResponseProcessingOp<MobileContentIconModerationResponse>>>
            MOBILE_CONTENT_ICON_OPERATIONS = List.of(
            SetMobileContentIconStatusModerateAndBsSyncedOp.class,
            MobileContentIconInsertOrUpdateModerationReasonsOp.class
    );

    private final ModerationOperationModeProvider moderationOperationModeProvider;

    @Autowired
    public MobileContentIconOperations(ApplicationContext applicationContext,
                                       ModerationOperationModeProvider moderationOperationModeProvider) {
        super(applicationContext);
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<MobileContentIconModerationResponse>>> getOperationClasses() {
        return MOBILE_CONTENT_ICON_OPERATIONS;
    }

    @Override
    protected boolean restrictedModeEnabled(MobileContentIconModerationResponse response) {
        return moderationOperationModeProvider.getMode(ModerationObjectType.MOBILE_CONTENT_ICON).equals(RESTRICTED);
    }
}
