package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations

import org.springframework.context.ApplicationContext
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.moderation.model.promoextension.PromoExtensionModerationResponse
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.promoextension.PromoExtensionDeleteFromModReasonsOp
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.promoextension.PromoExtensionInsertOrUpdateModerationReasonOp
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.promoextension.SetPromoExtensionStatusModerateOp

@Component
class PromoExtensionOperations(applicationContext: ApplicationContext) :
    BaseResponseOperationsChain<PromoExtensionModerationResponse>(applicationContext) {

    override fun getOperationClasses(): List<Class<out ModerationResponseProcessingOp<PromoExtensionModerationResponse>>> =
        listOf(
            SetPromoExtensionStatusModerateOp::class.java,
            PromoExtensionDeleteFromModReasonsOp::class.java,
            PromoExtensionInsertOrUpdateModerationReasonOp::class.java,
        )
}
