package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.jooq.Configuration;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResultResponse;
import ru.yandex.direct.core.entity.moderation.model.ModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationResult;
import ru.yandex.direct.core.entity.moderation.repository.bulk_update.BulkUpdateHolder;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;

public interface ResponseOperationsChain<T extends AbstractModerationResultResponse<?
        extends ModerationMeta, ?
        extends ModerationResult>> {

    List<Class<? extends ModerationResponseProcessingOp<T>>> getOperationClasses();

    void accept(Configuration cfg, BulkUpdateHolder bulkUpdateHolder, List<T> objects);
}
