package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.sitelinks.SitelinksModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.sitelinks.SetSitelinksStatusModerateOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.sitelinks.SitelinksInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.sitelinks.SitelinksUpdateApiDomainStatOp;

@Component
public class SitelinksOperations extends BaseResponseOperationsChain<SitelinksModerationResponse> {

    private static final List<Class<? extends ModerationResponseProcessingOp<SitelinksModerationResponse>>> SITELINKS_OPERATIONS =
            List.of(
                    SetSitelinksStatusModerateOp.class,
                    SitelinksInsertOrUpdateModerationReasonsOp.class,
                    SitelinksUpdateApiDomainStatOp.class
            );

    @Autowired
    public SitelinksOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<SitelinksModerationResponse>>> getOperationClasses() {
        return SITELINKS_OPERATIONS;
    }
}
