package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import com.google.common.collect.ImmutableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannersInsertOrUpdateModerationReasonsOp;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;

import static ru.yandex.direct.core.entity.moderation.ModerationOperationMode.RESTRICTED;

@Component
public class TextBannerOperations extends BannerOperations {
    private static final List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> TEXT_BANNER_OPERATIONS =
            ImmutableList.<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>>builder()
                    .addAll(BANNERS_OPERATIONS)
                    .add(BannersInsertOrUpdateModerationReasonsOp.class)
                    .build();

    private final ModerationOperationModeProvider moderationOperationModeProvider;

    @Autowired
    public TextBannerOperations(ApplicationContext applicationContext,
                                ModerationOperationModeProvider moderationOperationModeProvider) {
        super(applicationContext);
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerModerationResponse>>> getOperationClasses() {
        return TEXT_BANNER_OPERATIONS;
    }

    @Override
    protected boolean restrictedModeEnabled(BannerModerationResponse response) {
        if (BannersBannerType.mobile_content.equals(response.getMeta().getBannerType())) {
            return RESTRICTED.equals(moderationOperationModeProvider.getMode(ModerationObjectType.MOBILE_CONTENT));
        }
        if (BannersBannerType.dynamic.equals(response.getMeta().getBannerType())) {
            return RESTRICTED.equals(moderationOperationModeProvider.getMode(ModerationObjectType.DYNAMIC));
        }
        return RESTRICTED.equals(moderationOperationModeProvider.getMode(ModerationObjectType.TEXT_AD));
    }
}
