package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.turbolandings.TurbolandingsModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.turbolandings.SetTurbolandingStatusModerateOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.turbolandings.TurbolandingsInsertOrUpdateModerationReasonsOp;

@Component
public class TurbolandingOperations extends BaseResponseOperationsChain<TurbolandingsModerationResponse> {

    private static final List<Class<? extends ModerationResponseProcessingOp<TurbolandingsModerationResponse>>> TURBOLANDING_OPERATIONS =
            List.of(
                    SetTurbolandingStatusModerateOp.class,
                    TurbolandingsInsertOrUpdateModerationReasonsOp.class
            );


    @Autowired
    public TurbolandingOperations(ApplicationContext applicationContext) {
        super(applicationContext);
    }


    @Override
    public List<Class<? extends ModerationResponseProcessingOp<TurbolandingsModerationResponse>>> getOperationClasses() {
        return TURBOLANDING_OPERATIONS;
    }
}
