package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannerAssetUpdateApiDomainStatOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.SetVcardStatusModerateOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.VcardDeleteFromModReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.VcardInsertOrUpdateModerationReasonsOp;

import static ru.yandex.direct.core.entity.moderation.ModerationOperationMode.RESTRICTED;

@Component
public class VcardOperations extends BaseResponseOperationsChain<BannerAssetModerationResponse> {
    private static final List<Class<? extends ModerationResponseProcessingOp<BannerAssetModerationResponse>>> VCARD_OPERATIONS =
            List.of(
                    SetVcardStatusModerateOp.class,
                    VcardDeleteFromModReasonsOp.class,
                    VcardInsertOrUpdateModerationReasonsOp.class,
                    BannerAssetUpdateApiDomainStatOp.class
            );

    private final ModerationOperationModeProvider moderationOperationModeProvider;

    @Autowired
    public VcardOperations(ApplicationContext applicationContext,
                           ModerationOperationModeProvider moderationOperationModeProvider) {
        super(applicationContext);
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerAssetModerationResponse>>> getOperationClasses() {
        return VCARD_OPERATIONS;
    }

    @Override
    protected boolean restrictedModeEnabled(BannerAssetModerationResponse response) {
        return RESTRICTED.equals(moderationOperationModeProvider.getMode(ModerationObjectType.BANNER_VCARD));
    }
}
