package ru.yandex.direct.core.entity.moderation.service.receiving.processing_configurations;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerVideoAdditionModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.ModerationResponseProcessingOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.BannerVideoAdditionUpdateApiDomainStatOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.SetVideoAdditionStatusModerateOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.VideoAdditionDeleteFromModReasonsOp;
import ru.yandex.direct.core.entity.moderation.service.receiving.operations.banners.VideoAdditionInsertOrUpdateModerationReasonsOp;

import static ru.yandex.direct.core.entity.moderation.ModerationOperationMode.RESTRICTED;

@Component
public class VideoAdditionOperations extends BaseResponseOperationsChain<BannerVideoAdditionModerationResponse> {
    private static final List<Class<? extends ModerationResponseProcessingOp<BannerVideoAdditionModerationResponse>>> VIDEO_ADDITION_OPERATIONS =
            List.of(
                    SetVideoAdditionStatusModerateOp.class,
                    VideoAdditionDeleteFromModReasonsOp.class,
                    VideoAdditionInsertOrUpdateModerationReasonsOp.class,
                    BannerVideoAdditionUpdateApiDomainStatOp.class
            );

    private final ModerationOperationModeProvider moderationOperationModeProvider;

    @Autowired
    public VideoAdditionOperations(ApplicationContext applicationContext,
                                   ModerationOperationModeProvider moderationOperationModeProvider) {
        super(applicationContext);
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public List<Class<? extends ModerationResponseProcessingOp<BannerVideoAdditionModerationResponse>>> getOperationClasses() {
        return VIDEO_ADDITION_OPERATIONS;
    }

    @Override
    protected boolean restrictedModeEnabled(BannerVideoAdditionModerationResponse response) {
        return RESTRICTED.equals(moderationOperationModeProvider.getMode(ModerationObjectType.BANNER_VIDEO_ADDITION));
    }
}
