package ru.yandex.direct.core.entity.moderation.service.receiving.processor;

import java.util.List;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResponse;
import ru.yandex.direct.core.entity.moderation.model.ModerationMeta;

import static java.util.Comparator.comparingLong;

public class ChooseResponseWithMaxVersion implements ModerateResponseChooser {
    public static final ChooseResponseWithMaxVersion INSTANCE = new ChooseResponseWithMaxVersion();

    private ChooseResponseWithMaxVersion() {
    }

    @Override
    public <T extends AbstractModerationResponse<? extends ModerationMeta>> T apply(
            List<T> ts, ModerationResponseParser<T, ?> responseParser) {
        return ts.stream()
                .max(comparingLong(responseParser::getVersion).thenComparing(responseParser::getUnixtime))
                .orElseThrow();
    }
}
