package ru.yandex.direct.core.entity.moderation.service.receiving.processor;

import java.util.List;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResponse;
import ru.yandex.direct.core.entity.moderation.model.ModerationMeta;

public interface ModerationResponseParser<T extends AbstractModerationResponse<? extends ModerationMeta>, U> {
    Long getId(T response);

    Long getVersion(T response);

    List<Long> getReasons(T response);

    Long getUnixtime(T response);

    boolean isValid(T response);

    boolean hasCriticalReason(T response);

    U getKey(T response);
}
