package ru.yandex.direct.core.entity.moderation.service.receiving.processor;

import java.util.List;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResultResponse;
import ru.yandex.direct.core.entity.moderation.model.ModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationResult;

public class ModerationResponseProcessingResult<T extends AbstractModerationResultResponse<? extends ModerationMeta,
        ? extends ModerationResult>> {
    private final List<T> successfulResponses;
    private final int unknownResponses;

    public ModerationResponseProcessingResult(List<T> successfulResponses, int unknownResponses) {
        this.successfulResponses = successfulResponses;
        this.unknownResponses = unknownResponses;
    }

    public List<T> getSuccessfulResponses() {
        return successfulResponses;
    }

    public int getUnknownResponses() {
        return unknownResponses;
    }
}
