package ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerVideoAdditionModerationResponse;
import ru.yandex.direct.core.entity.moderationdiag.service.ModerationDiagService;

@Component
public class BannerVideoAdditionResponseParser
        extends BaseBannerAssetResponseParser<BannerVideoAdditionModerationResponse, Pair<Long, Long>> {

    public BannerVideoAdditionResponseParser(ModerationDiagService moderationDiagService) {
        super(moderationDiagService);
    }

    @Override
    public Pair<Long, Long> getKey(BannerVideoAdditionModerationResponse response) {
        return Pair.of(response.getMeta().getBannerId(), response.getMeta().getCreativeId());
    }
}
