package ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser;

import java.util.EnumSet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.bannerstorage.BannerstorageCreativeModerationResponse;
import ru.yandex.direct.core.entity.moderationdiag.service.ModerationDiagService;

@Component
public class BannerstorageCreativeResponseParser extends BaseResponseParser<BannerstorageCreativeModerationResponse, Long>
        implements BaseResponseParserSingleKey<BannerstorageCreativeModerationResponse> {

    private static final Logger logger = LoggerFactory.getLogger(BannerstorageCreativeResponseParser.class);

    @Autowired
    public BannerstorageCreativeResponseParser(ModerationDiagService moderationDiagService) {
        super(moderationDiagService);
    }

    @Override
    public Long getId(BannerstorageCreativeModerationResponse response) {
        return response.getMeta().getCreativeId();
    }

    @Override
    public boolean isValid(BannerstorageCreativeModerationResponse response) {
        if (response.getResult().getVerdict() == null || !EnumSet.of(ModerationDecision.Yes, ModerationDecision.No)
                .contains(response.getResult().getVerdict())) {
            logger.error("Unknown verdict {}.", response.getResult().getVerdict());
            return false;
        }

        return true;
    }
}
