package ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser;

import java.util.EnumSet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.asset.BaseBannerAssetModerationResponse;
import ru.yandex.direct.core.entity.moderationdiag.service.ModerationDiagService;

public abstract class BaseBannerAssetResponseParser<T extends BaseBannerAssetModerationResponse<? extends BannerAssetModerationMeta>, U>
        extends BaseBannerResponseParser<T, U> {
    private static final Logger logger = LoggerFactory.getLogger(BaseBannerAssetResponseParser.class);

    @Autowired
    public BaseBannerAssetResponseParser(ModerationDiagService moderationDiagService) {
        super(moderationDiagService);
    }

    @Override
    public boolean isValid(BaseBannerAssetModerationResponse response) {
        if (response.getResult().getVerdict() == null || !EnumSet.of(ModerationDecision.Yes, ModerationDecision.No)
                .contains(response.getResult().getVerdict())) {
            logger.error("Unknown verdict {}.", response.getResult().getVerdict());
            return false;
        }

        return true;
    }


}
