package ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResultResponse;
import ru.yandex.direct.core.entity.moderation.model.BaseModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationResult;
import ru.yandex.direct.core.entity.moderation.service.receiving.processor.ModerationResponseParser;
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiag;
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagType;
import ru.yandex.direct.core.entity.moderationdiag.service.ModerationDiagService;

public abstract class BaseResponseParser<T extends AbstractModerationResultResponse<? extends BaseModerationMeta,
        ? extends ModerationResult>, U> implements ModerationResponseParser<T, U> {

    private final ModerationDiagService moderationDiagService;

    public BaseResponseParser(ModerationDiagService moderationDiagService) {
        this.moderationDiagService = moderationDiagService;
    }

    @Override
    public Long getVersion(T response) {
        return response.getMeta().getVersionId();
    }

    @Override
    public List<Long> getReasons(T response) {
        var r = response.getResult().getReasons();
        return r == null ? List.of() : r;
    }

    @Override
    public Long getUnixtime(T response) {
        return response.getUnixtime();
    }

    @Override
    public boolean hasCriticalReason(T response) {
        if (response.getResult().getReasons() == null || response.getResult().getReasons().isEmpty()) {
            return false;
        }

        Map<Long, ModerationDiag> reasonMap = moderationDiagService.get(ModerationDiagType.COMMON);

        return response.getResult().getReasons().stream()
                .anyMatch(el -> reasonMap.containsKey(el) && reasonMap.get(el).getUnbanIsProhibited());
    }
}
