package ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser;

import java.util.EnumSet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationResponse;
import ru.yandex.direct.core.entity.moderationdiag.service.ModerationDiagService;

@Component
public class MobileContentIconResponseParser extends BaseResponseParser<MobileContentIconModerationResponse, Long>
        implements BaseResponseParserSingleKey<MobileContentIconModerationResponse> {
    private static final Logger logger = LoggerFactory.getLogger(MobileContentIconResponseParser.class);

    @Autowired
    public MobileContentIconResponseParser(ModerationDiagService moderationDiagService) {
        super(moderationDiagService);
    }

    @Override
    public Long getId(MobileContentIconModerationResponse response) {
        return response.getMeta().getMobileContentId();
    }

    @Override
    public boolean isValid(MobileContentIconModerationResponse response) {
        if (response.getResult().getVerdict() == null || !EnumSet.of(ModerationDecision.Yes, ModerationDecision.No)
                .contains(response.getResult().getVerdict())) {
            logger.error("Unknown verdict {}.", response.getResult().getVerdict());
            return false;
        }
        return true;
    }
}
