package ru.yandex.direct.core.entity.moderation.service.receiving.processor.response_parser

import org.slf4j.Logger
import org.slf4j.LoggerFactory
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.moderation.model.ModerationDecision
import ru.yandex.direct.core.entity.moderation.model.promoextension.PromoExtensionModerationResponse
import ru.yandex.direct.core.entity.moderationdiag.service.ModerationDiagService
import java.util.EnumSet

@Component
class PromoExtensionResponseParser(
    moderationDiagService: ModerationDiagService,
) : BaseResponseParser<PromoExtensionModerationResponse, Long>(moderationDiagService)
  , BaseResponseParserSingleKey<PromoExtensionModerationResponse> {

    private val logger: Logger = LoggerFactory.getLogger(PromoExtensionResponseParser::class.java)

    override fun getId(response: PromoExtensionModerationResponse) = response.meta!!.promoExtensionId

    override fun isValid(response: PromoExtensionModerationResponse): Boolean {
        if (response.result!!.verdict == null || !EnumSet.of(ModerationDecision.Yes, ModerationDecision.No)
                .contains(response.result!!.verdict)) {
            logger.error("Unknown verdict {}.", response.result!!.verdict)
            return false
        }

        return true
    }
}
