package ru.yandex.direct.core.entity.moderation.service.sending;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerButtonWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.model.ClientFlags;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerButtonModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerButtonRequestData;
import ru.yandex.direct.core.entity.moderation.repository.sending.BannerButtonsSendingRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.AutoAcceptanceType;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames.DIRECT_SERVICE;

@ModerationSender
public class BannerButtonSender extends BaseAssetSender<Long, BannerButtonModerationRequest,
        BannerButtonWithModerationInfo> {
    private static final Logger logger = LoggerFactory.getLogger(BannerButtonSender.class);

    public final static long VERSION_OFFSET = 50000L;

    @Autowired
    public BannerButtonSender(DslContextProvider dslContextProvider,
                              BannerButtonsSendingRepository bannerButtonsSendingRepository,
                              ModerationOperationModeProvider moderationOperationModeProvider,
                              RemoderationFlagsRepository remoderationFlagsRepository,
                              CampaignRepository campaignRepository) {
        super(dslContextProvider, bannerButtonsSendingRepository, moderationOperationModeProvider,
                remoderationFlagsRepository, campaignRepository,
                RemoderationType.BANNER_BUTTON, AutoAcceptanceType.BANNER_BUTTON);
    }

    @Override
    public String typeName() {
        return "banner-button";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected BannerButtonModerationRequest convert(BannerButtonWithModerationInfo moderationInfo,
                                                    long version) {
        BannerButtonModerationRequest request = new BannerButtonModerationRequest();
        request.setService(DIRECT_SERVICE);
        request.setType(ModerationObjectType.BANNER_BUTTONS);

        BannerAssetModerationMeta meta = new BannerAssetModerationMeta();
        meta.setUid(moderationInfo.getUid());
        meta.setVersionId(version);
        meta.setClientId(moderationInfo.getClientId());
        meta.setCampaignId(moderationInfo.getCampaignId());
        meta.setBannerId(moderationInfo.getBid());
        meta.setAdGroupId(moderationInfo.getAdGroupId());

        BannerButtonRequestData bannerButtonRequestData = new BannerButtonRequestData();
        bannerButtonRequestData.setHref(moderationInfo.getHref());
        bannerButtonRequestData.setButtonText(moderationInfo.getCaption());
        if (moderationInfo.getClientFlags().contains(ClientFlags.AS_SOON_AS_POSSIBLE.getTypedValue())) {
            bannerButtonRequestData.setAsSoonAsPossible(true);
        }

        request.setMeta(meta);
        request.setData(bannerButtonRequestData);

        return request;
    }

    @Override
    protected long getVersion(BannerButtonWithModerationInfo object) {
        if (object.getVersion() != null) {
            return object.getVersion() + 1;
        } else {
            return VERSION_OFFSET;
        }
    }
}
