package ru.yandex.direct.core.entity.moderation.service.sending;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerLogoWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.model.ClientFlags;
import ru.yandex.direct.core.entity.image.model.AvatarHost;
import ru.yandex.direct.core.entity.image.model.BannerImageFormatNamespace;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerLogoModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerLogoRequestData;
import ru.yandex.direct.core.entity.moderation.repository.sending.BannerLogoSendingRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.AutoAcceptanceType;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames.DIRECT_SERVICE;

@ModerationSender
public class BannerLogoSender
        extends BaseAssetSender<Long, BannerLogoModerationRequest, BannerLogoWithModerationInfo> {
    private static final Logger logger = LoggerFactory.getLogger(BannerLogoSender.class);

    public final static long VERSION_OFFSET = 40000L;

    @Autowired
    public BannerLogoSender(DslContextProvider dslContextProvider,
                            BannerLogoSendingRepository bannerLogoSendingRepository,
                            ModerationOperationModeProvider moderationOperationModeProvider,
                            RemoderationFlagsRepository remoderationFlagsRepository,
                            CampaignRepository campaignRepository) {
        super(dslContextProvider, bannerLogoSendingRepository, moderationOperationModeProvider,
                remoderationFlagsRepository, campaignRepository,
                RemoderationType.BANNER_LOGO, AutoAcceptanceType.BANNER_LOGO);
    }

    @Override
    public String typeName() {
        return "banner-logos";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected BannerLogoModerationRequest convert(BannerLogoWithModerationInfo moderationInfo,
                                                  long version) {
        BannerLogoModerationRequest request = new BannerLogoModerationRequest();
        request.setService(DIRECT_SERVICE);
        request.setType(ModerationObjectType.BANNER_LOGOS);

        BannerAssetModerationMeta meta = new BannerAssetModerationMeta();
        meta.setUid(moderationInfo.getUid());
        meta.setVersionId(version);
        meta.setClientId(moderationInfo.getClientId());
        meta.setCampaignId(moderationInfo.getCampaignId());
        meta.setBannerId(moderationInfo.getBid());
        meta.setAdGroupId(moderationInfo.getAdGroupId());

        BannerLogoRequestData bannerLogoRequestData = new BannerLogoRequestData();
        bannerLogoRequestData.setImageHash(moderationInfo.getImageHash());

        bannerLogoRequestData.setHost(AvatarHost.toSource(moderationInfo.getAvatarsHost()).getLiteral());
        bannerLogoRequestData.setMdsGroupId(moderationInfo.getMdsGroupId());
        bannerLogoRequestData.setNamespace(BannerImageFormatNamespace.toSource(moderationInfo.getNamespace()).getLiteral());

        if (moderationInfo.getClientFlags().contains(ClientFlags.AS_SOON_AS_POSSIBLE.getTypedValue())) {
            bannerLogoRequestData.setAsSoonAsPossible(true);
        }

        request.setMeta(meta);
        request.setData(bannerLogoRequestData);

        return request;
    }

    @Override
    protected long getVersion(BannerLogoWithModerationInfo object) {
        if (object.getVersion() != null) {
            return object.getVersion() + 1;
        } else {
            return VERSION_OFFSET;
        }
    }
}
