package ru.yandex.direct.core.entity.moderation.service.sending;

import java.util.Collection;

import org.jooq.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerVcardWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerVcardModerationData;
import ru.yandex.direct.core.entity.moderation.model.asset.BannerVcardModerationRequest;
import ru.yandex.direct.core.entity.moderation.repository.sending.BannerVcardSendingRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.AutoAcceptanceType;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.core.entity.moderation.ModerationOperationMode.RESTRICTED;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.BANNER_VCARD;
import static ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames.DIRECT_SERVICE;

@ModerationSender
public class BannerVcardSender
        extends BaseAssetSender<Long, BannerVcardModerationRequest, BannerVcardWithModerationInfo> {

    public static final long INITIAL_VERSION = 75_000L;

    private static final Logger logger = LoggerFactory.getLogger(BannerVcardSender.class);

    @Autowired
    public BannerVcardSender(DslContextProvider dslContextProvider,
                             BannerVcardSendingRepository moderationSendingRepository,
                             ModerationOperationModeProvider moderationOperationModeProvider,
                             RemoderationFlagsRepository remoderationFlagsRepository,
                             CampaignRepository campaignRepository) {
        super(dslContextProvider, moderationSendingRepository, moderationOperationModeProvider,
                remoderationFlagsRepository, campaignRepository,
                RemoderationType.CONTACTS, AutoAcceptanceType.CONTACTS);
    }

    @Override
    public String typeName() {
        return "banner-vcard";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected BannerVcardModerationRequest convert(BannerVcardWithModerationInfo moderationInfo, long version) {
        BannerVcardModerationRequest request = new BannerVcardModerationRequest();
        request.setService(DIRECT_SERVICE);
        request.setType(BANNER_VCARD);

        BannerVcardModerationData data = new BannerVcardModerationData();

        //Информация об организации
        data.setCompanyName(moderationInfo.getName());
        data.setWorkTime(moderationInfo.getWorktime());
        data.setContactPerson(moderationInfo.getContactPerson());
        data.setPhone(moderationInfo.getPhone());
        data.setEmail(moderationInfo.getEmail());
        data.setExtraMessage(moderationInfo.getExtraMessage());
        data.setOgrn(moderationInfo.getOgrn());
        data.setImLogin(moderationInfo.getImLogin());
        data.setImClient(moderationInfo.getImClient());

        // Адрес
        data.setCountry(moderationInfo.getCountry());
        data.setCity(moderationInfo.getCity());
        data.setStreet(moderationInfo.getStreet());
        data.setHouse(moderationInfo.getHouse());
        data.setBuild(moderationInfo.getBuild());
        data.setApart(moderationInfo.getApart());

        request.setData(data);

        BannerAssetModerationMeta meta = new BannerAssetModerationMeta();
        meta.setUid(moderationInfo.getUid());
        meta.setVersionId(version);
        meta.setClientId(moderationInfo.getClientId());
        meta.setCampaignId(moderationInfo.getCampaignId());
        meta.setBannerId(moderationInfo.getBid());
        meta.setAdGroupId(moderationInfo.getAdGroupId());

        request.setMeta(meta);
        return request;
    }

    @Override
    protected void postProcess(Configuration configuration, Collection<BannerVcardWithModerationInfo> objects) {
        // в ограниченном режиме пропускаем пост-процессинг
        if (getModerationOperationModeProvider().getMode(BANNER_VCARD).equals(RESTRICTED)) {
            return;
        }
        super.postProcess(configuration, objects);
    }

    @Override
    protected long getVersion(BannerVcardWithModerationInfo object) {
        if (object.getVersion() != null) {
            return Math.max(INITIAL_VERSION, object.getVersion() + 1);
        } else {
            return INITIAL_VERSION;
        }
    }
}
