package ru.yandex.direct.core.entity.moderation.service.sending;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import org.jooq.Configuration;

import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.ModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow;
import ru.yandex.direct.core.entity.moderation.model.ModerationableWithBid;
import ru.yandex.direct.core.entity.moderation.repository.sending.ModerationSendingRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.AutoAcceptanceType;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.AUTO_ACCEPT;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.COMMON;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.MANUAL;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public abstract class BaseAssetSender
        <U, D extends ModerationRequest<? extends ModerationMeta>, E extends ModerationableWithBid>
        extends ModerationSendingService<U, D, E> {

    private final ModerationOperationModeProvider moderationOperationModeProvider;
    private final RemoderationFlagsRepository remoderationFlagsRepository;
    private final CampaignRepository campaignRepository;

    private final RemoderationType remoderationType;
    private final AutoAcceptanceType autoAcceptanceType;

    public BaseAssetSender(DslContextProvider dslContextProvider,
                           ModerationSendingRepository<U, E> moderationSendingRepository,
                           ModerationOperationModeProvider moderationOperationModeProvider,
                           RemoderationFlagsRepository remoderationFlagsRepository,
                           CampaignRepository campaignRepository,
                           RemoderationType remoderationType,
                           AutoAcceptanceType autoAcceptanceType) {
        super(dslContextProvider, moderationSendingRepository);
        this.moderationOperationModeProvider = moderationOperationModeProvider;
        this.remoderationFlagsRepository = remoderationFlagsRepository;
        this.campaignRepository = campaignRepository;
        this.remoderationType = remoderationType;
        this.autoAcceptanceType = autoAcceptanceType;
    }

    protected ModerationOperationModeProvider getModerationOperationModeProvider() {
        return moderationOperationModeProvider;
    }

    @Override
    protected void postProcess(Configuration configuration, Collection<E> objects) {
        // в ограниченном режиме пропускаем пост-процессинг
        if (moderationOperationModeProvider.isForcedRestrictedMode()) {
            return;
        }

        List<Long> bids = objects.stream().map(E::getBid).collect(Collectors.toList());
        remoderationFlagsRepository.removeRemoderationFlag(configuration, bids, remoderationType);
        remoderationFlagsRepository.removeAutoAcceptFlag(configuration, bids, autoAcceptanceType);

        campaignRepository.markReadyCampaignsAsSent(configuration, mapList(objects, E::getCampaignId));
    }

    @Override
    protected ModerationWorkflow getWorkflow(E moderationInfo) {
        if (moderationInfo.getBidReModerate() != null) {
            return MANUAL;
        } else if (moderationInfo.getBidAutoModerate() != null) {
            return AUTO_ACCEPT;
        } else {
            return COMMON;
        }
    }
}
