package ru.yandex.direct.core.entity.moderation.service.sending;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.BannerLink;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow;
import ru.yandex.direct.core.entity.moderation.model.cpm.video.CpmVideoBannerModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.cpm.video.CpmVideoBannerRequestData;
import ru.yandex.direct.core.entity.moderation.repository.sending.BannerWithCreativesModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.BannersSendingContext;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.regions.GeoTreeFactory;

import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.AUTO_ACCEPT;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.COMMON;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.MANUAL;

public abstract class BaseCpmVideoBannerSender extends BaseBannerSender<CpmVideoBannerModerationRequest, BannerWithModerationInfo,
        BannerModerationMeta> {

    public static final long INITIAL_VERSION = 64L;

    private final GeoTreeFactory geoTreeFactory;

    public BaseCpmVideoBannerSender(DslContextProvider dslContextProvider,
                                    BannerWithCreativesModerationRepository bannerModerationRepository,
                                    GeoTreeFactory geoTreeFactory,
                                    RemoderationFlagsRepository remoderationFlagsRepository,
                                    CampaignRepository campaignRepository,
                                    HrefParameterizingService hrefParameterizingService, FeatureService featureService,
                                    BusinessUnitModerationRepository businessUnitModerationRepository,
                                    ModerationFlagsConverter moderationFlagsConverter,
                                    ModerationOperationModeProvider moderationOperationModeProvider) {
        super(dslContextProvider, bannerModerationRepository, remoderationFlagsRepository, campaignRepository,
                hrefParameterizingService, featureService, businessUnitModerationRepository,
                moderationFlagsConverter, moderationOperationModeProvider);

        // При отправке в модерацию баннеров всех типов нужно использовать российское гео дерево (DIRECTSUP-33318)
        this.geoTreeFactory = geoTreeFactory;
    }

    @Override
    public long initialVersion() {
        return INITIAL_VERSION;
    }

    @Override
    protected BannerModerationMeta makeMetaObject() {
        return new BannerModerationMeta();
    }

    protected abstract ModerationObjectType getModerationObjectType();

    @Override
    protected CpmVideoBannerModerationRequest convertBanner(BannerWithModerationInfo moderationInfo, long version) {
        CpmVideoBannerModerationRequest request = new CpmVideoBannerModerationRequest();

        request.setService(ModerationServiceNames.DIRECT_SERVICE);
        request.setType(getModerationObjectType());

        BannerModerationMeta meta = createMetaFromBanner(moderationInfo);
        meta.setVersionId(version);

        CpmVideoBannerRequestData data = new CpmVideoBannerRequestData();

        data.setDomain(moderationInfo.getDomain());
        data.setBody(moderationInfo.getBody());
        data.setTitle(moderationInfo.getTitle());
        data.setTitleExtension(moderationInfo.getTitleExtension());
        data.setCreativeId(moderationInfo.getCreativeId());
        data.setHref(moderationInfo.getHref());
        data.setPreviewUrl(moderationInfo.getCreativePreviewUrl());
        data.setGeo(StreamEx.of(getGeoTree().getModerationCountries(moderationInfo.getGeo())).joining(","));
        data.setLinks(extractBannerLinks(moderationInfo));

        //todo copy moderationInfo (?)
        data.setModerationInfo(moderationInfo.getModerateInfo());

        request.setMeta(meta);
        request.setData(data);

        return request;
    }

    @Override
    protected ModerationWorkflow getWorkflow(BannerWithModerationInfo moderationInfo) {
        if (moderationInfo.getBidReModerate() != null) {
            return MANUAL;
        } else if (moderationInfo.getBidAutoModerate() != null) {
            return AUTO_ACCEPT;
        } else {
            return COMMON;
        }
    }

    private GeoTree getGeoTree() {
        // При отправке в модерацию баннеров всех типов нужно использовать российское гео дерево (DIRECTSUP-33318)
        return geoTreeFactory.getRussianGeoTree();
    }

    private List<BannerLink> extractBannerLinks(BannerWithModerationInfo moderationInfo) {
        BannersSendingContext bannersSendingContext = (BannersSendingContext) getContext();
        List<BannerLink> links = new ArrayList<>();

        if (moderationInfo.getHref() != null || moderationInfo.getTurbolandingHref() != null) {
            links.add(createBannerLink(bannersSendingContext, moderationInfo.getHref(),
                    moderationInfo.getTurbolandingHref()));
        }

        for (var additionalHref : moderationInfo.getAdditionalHrefs()) {
            links.add(createBannerLink(bannersSendingContext, additionalHref.getHref(), null));
        }

        return links;
    }

    private BannerLink createBannerLink(BannersSendingContext bannersSendingContext, String href,
                                        @Nullable String turbolandingHref) {
        var link = new BannerLink().setHref(href).setParametrizedHref(bannersSendingContext.getParameterizedUrl(href));
        if (turbolandingHref != null) {
            link.setMobileHref(turbolandingHref);
        }
        return link;
    }
}
