package ru.yandex.direct.core.entity.moderation.service.sending;

import java.util.Collection;

import org.jooq.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.banner.model.CalloutModerateType;
import ru.yandex.direct.core.entity.banner.model.CalloutWithModerationInfo;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow;
import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationData;
import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationRequest;
import ru.yandex.direct.core.entity.moderation.repository.sending.CalloutSendingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.core.entity.moderation.ModerationOperationMode.RESTRICTED;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.AUTO_ACCEPT;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.COMMON;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.MANUAL;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.CALLOUT;
import static ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames.DIRECT_SERVICE;

@ModerationSender
public class CalloutSender extends ModerationSendingService<Long, CalloutModerationRequest,
        CalloutWithModerationInfo> {

    private static final Logger logger = LoggerFactory.getLogger(CalloutSender.class);

    public final static long INITIAL_VERSION = 10L;

    private final ModerationOperationModeProvider moderationOperationModeProvider;

    public CalloutSender(DslContextProvider dslContextProvider,
                         CalloutSendingRepository calloutSendingRepository,
                         ModerationOperationModeProvider moderationOperationModeProvider) {
        super(dslContextProvider, calloutSendingRepository);
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public String typeName() {
        return "callout";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected CalloutModerationRequest convert(CalloutWithModerationInfo moderationInfo, long version) {
        CalloutModerationData data = new CalloutModerationData();
        data.setText(moderationInfo.getText());

        CalloutModerationMeta meta = new CalloutModerationMeta();
        meta.setCalloutId(moderationInfo.getCalloutId());
        meta.setClientId(moderationInfo.getClientId());
        meta.setUid(moderationInfo.getUid());
        meta.setVersionId(version);

        CalloutModerationRequest request = new CalloutModerationRequest();
        request.setService(DIRECT_SERVICE);
        request.setType(CALLOUT);
        request.setWorkflow(getWorkflow(moderationInfo));
        request.setData(data);
        request.setMeta(meta);

        return request;
    }

    protected ModerationWorkflow getWorkflow(CalloutWithModerationInfo moderationInfo) {
        if (CalloutModerateType.PRE.equals(moderationInfo.getModerateType())) {
            return MANUAL;
        } else if (CalloutModerateType.AUTO.equals(moderationInfo.getModerateType())) {
            return AUTO_ACCEPT;
        } else {
            return COMMON;
        }
    }

    @Override
    protected void postProcess(Configuration configuration, Collection<CalloutWithModerationInfo> objects) {
        if (moderationOperationModeProvider.getMode(CALLOUT).equals(RESTRICTED)) {
            return;
        }
        // в будущем здесь может появиться какая-то логика
    }

    @Override
    protected long getVersion(CalloutWithModerationInfo calloutWithModerationInfo) {
        if (calloutWithModerationInfo.getVersion() != null) {
            return calloutWithModerationInfo.getVersion() + 1;
        } else {
            return INITIAL_VERSION;
        }
    }
}
