package ru.yandex.direct.core.entity.moderation.service.sending;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.contentpromotion.ContentPromotionBannerModerationRequest;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.ContentPromotionBannerRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames;
import ru.yandex.direct.core.entity.moderation.service.contentpromotion.subtype.ContentPromotionModerationTypeSupportFacade;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.enums.BannersBannerType.content_promotion;

@ModerationSender
public class ContentPromotionBannerSender extends BaseBannerSender<ContentPromotionBannerModerationRequest,
        BannerWithModerationInfo, BannerModerationMeta> {
    private static final Logger logger = LoggerFactory.getLogger(ContentPromotionBannerSender.class);

    private final ContentPromotionModerationTypeSupportFacade contentPromotionModerationTypeSupportFacade;

    @Autowired
    public ContentPromotionBannerSender(DslContextProvider dslContextProvider,
                                        ContentPromotionModerationTypeSupportFacade contentPromotionModerationTypeSupportFacade,
                                        ContentPromotionBannerRepository contentPromotionBannerRepository,
                                        RemoderationFlagsRepository remoderationFlagsRepository,
                                        CampaignRepository campaignRepository,
                                        HrefParameterizingService hrefParameterizingService,
                                        FeatureService featureService,
                                        BusinessUnitModerationRepository businessUnitModerationRepository,
                                        ModerationFlagsConverter moderationFlagsConverter,
                                        ModerationOperationModeProvider moderationOperationModeProvider) {
        super(dslContextProvider, contentPromotionBannerRepository, remoderationFlagsRepository, campaignRepository,
                hrefParameterizingService, featureService, businessUnitModerationRepository,
                moderationFlagsConverter, moderationOperationModeProvider);
        this.contentPromotionModerationTypeSupportFacade = contentPromotionModerationTypeSupportFacade;
    }

    @Override
    protected BannerModerationMeta makeMetaObject() {
        return new BannerModerationMeta();
    }

    @Override
    public String typeName() {
        return "content_promotion_banner";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected ContentPromotionBannerModerationRequest convertBanner(BannerWithModerationInfo moderationInfo,
                                                                    long version) {
        ContentPromotionBannerModerationRequest request = new ContentPromotionBannerModerationRequest();

        request.setService(ModerationServiceNames.DIRECT_SERVICE);

        String typeName = String.format("%s_%s",
                content_promotion.getLiteral(), moderationInfo.getContentPromotionType().name().toLowerCase());

        ModerationObjectType type = ModerationObjectType.getEnumByValue(typeName);

        if (type == null) {
            throw new IllegalStateException("Unknown content promotion object type " + moderationInfo.getContentPromotionType().name());
        }

        request.setType(type);

        request.setMeta(contentPromotionModerationTypeSupportFacade.buildModerationMeta(moderationInfo));
        request.setData(contentPromotionModerationTypeSupportFacade.buildModerationData(moderationInfo));

        return request;
    }
}
