package ru.yandex.direct.core.entity.moderation.service.sending;

import java.util.Collection;
import java.util.Map;

import org.jooq.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.verdictrequest.contentpromotion.ContentPromotionModerationVerdict;
import ru.yandex.direct.core.entity.moderation.model.verdictrequest.contentpromotion.ContentPromotionModerationVerdictRequest;
import ru.yandex.direct.core.entity.moderation.repository.sending.ContentPromotionVerdictRepository;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static java.lang.String.format;
import static ru.yandex.direct.core.entity.campaign.model.CampaignType.CONTENT_PROMOTION;
import static ru.yandex.direct.core.entity.moderation.model.verdictrequest.contentpromotion.ContentPromotionModerationVerdict.getContentPromotionModerationVerdict;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@ModerationSender
public class ContentPromotionVerdictRequestSender extends ModerationSendingService<Long,
        ContentPromotionModerationVerdictRequest, BannerWithModerationInfo> {
    private static final Logger logger = LoggerFactory.getLogger(ContentPromotionVerdictRequestSender.class);
    private Map<Long, Boolean> isContentPromotionInaccessibleByBannerId;

    @Autowired
    public ContentPromotionVerdictRequestSender(DslContextProvider dslContextProvider,
                                                ContentPromotionVerdictRepository contentPromotionVerdictRepository) {
        super(dslContextProvider, contentPromotionVerdictRepository);
    }

    public void setIsContentPromotionInaccessibleByBannerId(
            Map<Long, Boolean> isContentPromotionInaccessibleByBannerId) {
        this.isContentPromotionInaccessibleByBannerId = isContentPromotionInaccessibleByBannerId;
    }


    @Override
    public String typeName() {
        return "content_promotion_request_banner";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected ContentPromotionModerationVerdictRequest convert(BannerWithModerationInfo moderationInfo,
                                                               long version) {
        ContentPromotionModerationVerdictRequest request = new ContentPromotionModerationVerdictRequest();

        Long bid = moderationInfo.getId();
        request.setService(ModerationServiceNames.DIRECT_SERVICE);

        String typeName = format("%s_%s", CONTENT_PROMOTION.name(), moderationInfo.getContentPromotionType().name())
                .toLowerCase();

        ModerationObjectType type = ModerationObjectType.getEnumByValue(typeName);

        if (type == null) {
            throw new IllegalStateException("Unknown content promotion object type " + moderationInfo.getContentPromotionType().name());
        }

        request.setType(type);

        BannerModerationMeta meta = new BannerModerationMeta();

        meta.setBannerId(bid);
        meta.setAdGroupId(moderationInfo.getAdGroupId());
        meta.setCampaignId(moderationInfo.getCampaignId());
        meta.setClientId(moderationInfo.getClientId());
        meta.setUid(moderationInfo.getUid());
        meta.setVersionId(version);

        if (moderationInfo.getVersion() == null) {
            logger.warn("Trying to resend draft content promotion video banner, bid: {}", bid);
        }

        boolean isContentPromotionInaccessible = isContentPromotionInaccessibleByBannerId.get(moderationInfo.getId());

        ContentPromotionModerationVerdict verdict =
                getContentPromotionModerationVerdict(isContentPromotionInaccessible);

        request.setMeta(meta);
        request.setVerdict(verdict);

        return request;
    }

    @Override
    protected void postProcess(Configuration configuration, Collection<BannerWithModerationInfo> objects) {

    }

    @Override
    protected long getVersion(BannerWithModerationInfo object) {
        return nvl(object.getVersion(), 0L);
    }

    @Override
    protected void fillEssTag(ModerationRequest request, String essTag) {

    }
}
