package ru.yandex.direct.core.entity.moderation.service.sending;

import one.util.streamex.StreamEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.AspectRatio;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.cpm.audio.CpmAudioBannerModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.cpm.audio.CpmAudioBannerRequestData;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.CpmAudioBannersRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.regions.GeoTreeFactory;

import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.AUDIO_CREATIVE;

@ModerationSender
public class CpmAudioBannerSender extends BaseVideoBannerSender<CpmAudioBannerModerationRequest,
        BannerWithModerationInfo> {
    public static final int CPM_AUDIO_DEFAULT_WIDTH = 900;
    public static final int CPM_AUDIO_DEFAULT_HEIGHT = 900;
    private static final Logger logger = LoggerFactory.getLogger(CpmAudioBannerSender.class);
    private final GeoTreeFactory geoTreeFactory;

    @Autowired
    public CpmAudioBannerSender(DslContextProvider dslContextProvider,
                                GeoTreeFactory geoTreeFactory,
                                CpmAudioBannersRepository cpmAudioBannersRepository,
                                RemoderationFlagsRepository remoderationFlagsRepository,
                                CampaignRepository campaignRepository,
                                HrefParameterizingService hrefParameterizingService, FeatureService featureService,
                                BusinessUnitModerationRepository businessUnitModerationRepository,
                                ModerationFlagsConverter moderationFlagsConverter,
                                ModerationOperationModeProvider moderationOperationModeProvider) {
        super(dslContextProvider, cpmAudioBannersRepository, remoderationFlagsRepository, campaignRepository,
                hrefParameterizingService, featureService, businessUnitModerationRepository,
                moderationFlagsConverter, moderationOperationModeProvider);

        this.geoTreeFactory = geoTreeFactory;
    }

    @Override
    public String typeName() {
        return "cpm_audio_banner";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected CpmAudioBannerModerationRequest convertBanner(BannerWithModerationInfo moderationInfo, long version) {
        CpmAudioBannerModerationRequest request = new CpmAudioBannerModerationRequest();

        request.setService(ModerationServiceNames.DIRECT_SERVICE);
        request.setType(AUDIO_CREATIVE);

        BannerModerationMeta meta = createMetaFromBanner(moderationInfo);
        meta.setVersionId(version);

        CpmAudioBannerRequestData data = new CpmAudioBannerRequestData();

        data.setDomain(moderationInfo.getDomain());
        data.setHref(moderationInfo.getHref());
        data.setCreativeId(moderationInfo.getCreativeId());
        //noinspection ConstantConditions
        data.setCreativePreviewUrl(moderationInfo.getCreativePreviewUrl());
        data.setLivePreviewUrl(moderationInfo.getLivePreviewUrl());
        data.setDuration(moderationInfo.getDuration() == null ? -1 : moderationInfo.getDuration());
        data.setGeo(StreamEx.of(getGeoTree().getModerationCountries(moderationInfo.getGeo())).joining(","));

        data.setAspectRatio(new AspectRatio(CPM_AUDIO_DEFAULT_WIDTH, CPM_AUDIO_DEFAULT_HEIGHT));

        request.setMeta(meta);
        request.setData(data);

        return request;
    }

    private GeoTree getGeoTree() {
        // При отправке в модерацию баннеров всех типов нужно использовать российское гео дерево (DIRECTSUP-33318)
        return geoTreeFactory.getRussianGeoTree();
    }
}
