package ru.yandex.direct.core.entity.moderation.service.sending;

import java.net.MalformedURLException;
import java.net.URL;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.creative.model.ModerationInfo;
import ru.yandex.direct.core.entity.creative.model.ModerationInfoImage;
import ru.yandex.direct.core.entity.creative.model.ModerationInfoText;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow;
import ru.yandex.direct.core.entity.moderation.model.cpm.geopin.CpmGeoPinBannerModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.cpm.geopin.CpmGeoPinBannerRequestData;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.CpmGeoPinBannersRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.apache.commons.lang.StringUtils.isBlank;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.AUTO_ACCEPT;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.COMMON;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.MANUAL;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.GEO_PIN_CREATIVE;

@ModerationSender
public class CpmGeoPinBannerSender extends BaseBannerSender<CpmGeoPinBannerModerationRequest,
        BannerWithModerationInfo, BannerModerationMeta> {

    private static final String NAME = "headline";
    private static final String DESCRIPTION = "description";
    private static final String BUTTON_LINK = "domain";
    private static final String PHONE = "phone";
    private static final String IMAGE = "image";
    private static final String LOGO = "logo";

    private static final Logger logger = LoggerFactory.getLogger(CpmGeoPinBannerSender.class);

    @Autowired
    public CpmGeoPinBannerSender(DslContextProvider dslContextProvider,
                                 CpmGeoPinBannersRepository cpmGeoPinBannersRepository,
                                 RemoderationFlagsRepository remoderationFlagsRepository,
                                 CampaignRepository campaignRepository,
                                 HrefParameterizingService hrefParameterizingService, FeatureService featureService,
                                 BusinessUnitModerationRepository businessUnitModerationRepository,
                                 ModerationFlagsConverter moderationFlagsConverter,
                                 ModerationOperationModeProvider moderationOperationModeProvider) {
        super(dslContextProvider, cpmGeoPinBannersRepository, remoderationFlagsRepository, campaignRepository,
                hrefParameterizingService, featureService, businessUnitModerationRepository,
                moderationFlagsConverter, moderationOperationModeProvider);
    }

    @Override
    protected BannerModerationMeta makeMetaObject() {
        return new BannerModerationMeta();
    }

    @Override
    public String typeName() {
        return "cpm_geo_pin_banner";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected CpmGeoPinBannerModerationRequest convertBanner(BannerWithModerationInfo moderationInfo, long version) {
        CpmGeoPinBannerModerationRequest request = new CpmGeoPinBannerModerationRequest();

        request.setService(ModerationServiceNames.DIRECT_SERVICE);
        request.setType(GEO_PIN_CREATIVE);

        BannerModerationMeta meta = createMetaFromBanner(moderationInfo);
        meta.setVersionId(version);

        CpmGeoPinBannerRequestData data = new CpmGeoPinBannerRequestData();

        data.setPermalinkId(moderationInfo.getPermalinkId());
        data.setCreativeId(moderationInfo.getCreativeId());
        data.setCreativePreviewUrl(moderationInfo.getCreativePreviewUrl());

        ModerationInfo info = moderationInfo.getModerateInfo();
        data.setModerationInfo(info);

        for (ModerationInfoText text : info.getTexts()) {
            String content = text.getText();
            switch (text.getType()) {
                case NAME:
                    data.setName(content);
                    break;
                case DESCRIPTION:
                    data.setDescription(content);
                    break;
                case BUTTON_LINK:
                    data.setButtonLink(content);
                    data.setDomain(getDomain(content));
                    break;
                case PHONE:
                    data.setPhone(content);
                    break;
            }
        }

        for (ModerationInfoImage image : info.getImages()) {
            String url = image.getUrl();
            switch (image.getType()) {
                case IMAGE:
                    data.setImage(url);
                    break;
                case LOGO:
                    data.setLogo(url);
                    break;
            }
        }

        request.setMeta(meta);
        request.setData(data);

        return request;
    }

    private String getDomain(String url) {
        if (isBlank(url)) {
            return null;
        }
        try {
            return new URL(url).getHost();
        } catch (MalformedURLException ex) {
            logger.error("URI build or parse error for value %s. Href must be already validated. Skip error.", url, ex);
            return null;
        }
    }

    @Override
    protected ModerationWorkflow getWorkflow(BannerWithModerationInfo moderationInfo) {
        if (moderationInfo.getBidReModerate() != null) {
            return MANUAL;
        } else if (moderationInfo.getBidAutoModerate() != null) {
            return AUTO_ACCEPT;
        } else {
            return COMMON;
        }
    }

}
