package ru.yandex.direct.core.entity.moderation.service.sending;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.repository.BannerRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.DynamicBannerModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.core.entity.turbolanding.repository.TurboLandingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.regions.GeoTreeFactory;

@ModerationSender
public class DynamicBannerSender extends TextBannerSender {
    private static final Logger logger = LoggerFactory.getLogger(DynamicBannerSender.class);

    @Autowired
    public DynamicBannerSender(DslContextProvider dslContextProvider,
                               DynamicBannerModerationRepository moderationSendingRepository,
                               RemoderationFlagsRepository remoderationFlagsRepository,
                               CampaignRepository campaignRepository,
                               HrefParameterizingService hrefParameterizingService,
                               FeatureService featureService,
                               BusinessUnitModerationRepository businessUnitModerationRepository,
                               GeoTreeFactory geoTreeFactory, BannerRepository bannerRepository,
                               TurboLandingRepository turboLandingRepository,
                               ModerationOperationModeProvider moderationOperationModeProvider,
                               ModerationFlagsConverter moderationFlagsConverter) {
        super(dslContextProvider, moderationSendingRepository, remoderationFlagsRepository, campaignRepository,
                hrefParameterizingService, featureService, businessUnitModerationRepository, geoTreeFactory,
                bannerRepository, turboLandingRepository, moderationOperationModeProvider, moderationFlagsConverter);
    }

    @Override
    public String typeName() {
        return "dynamic_banner";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected ModerationObjectType getModerationObjectType() {
        return ModerationObjectType.DYNAMIC;
    }
}
