package ru.yandex.direct.core.entity.moderation.service.sending;

import one.util.streamex.StreamEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.BannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow;
import ru.yandex.direct.core.entity.moderation.model.cpm.in_banner.InBannerModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.cpm.in_banner.InBannerRequestData;
import ru.yandex.direct.core.entity.moderation.repository.sending.BannerWithCreativesModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.regions.GeoTreeFactory;

import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.AUTO_ACCEPT;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.COMMON;
import static ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow.MANUAL;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.IN_BANNER;

public class InBannerSender extends BaseBannerSender<InBannerModerationRequest,
        BannerWithModerationInfo, BannerModerationMeta> {
    private static final Logger logger = LoggerFactory.getLogger(InBannerSender.class);
    private final GeoTreeFactory geoTreeFactory;

    public static final long INITIAL_VERSION = 1L;

    public InBannerSender(DslContextProvider dslContextProvider,
                          BannerWithCreativesModerationRepository moderationSendingRepository,
                          RemoderationFlagsRepository remoderationFlagsRepository,
                          CampaignRepository campaignRepository,
                          HrefParameterizingService hrefParameterizingService, GeoTreeFactory geoTreeFactory,
                          FeatureService featureService,
                          BusinessUnitModerationRepository businessUnitModerationRepository,
                          ModerationFlagsConverter moderationFlagsConverter,
                          ModerationOperationModeProvider moderationOperationModeProvider) {
        super(dslContextProvider, moderationSendingRepository, remoderationFlagsRepository, campaignRepository,
                hrefParameterizingService, featureService, businessUnitModerationRepository,
                moderationFlagsConverter, moderationOperationModeProvider);

        this.geoTreeFactory = geoTreeFactory;
    }


    @Override
    public String typeName() {
        return "in_banner";
    }

    @Override
    public long initialVersion() {
        return INITIAL_VERSION;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected BannerModerationMeta makeMetaObject() {
        return new BannerModerationMeta();
    }

    @Override
    protected InBannerModerationRequest convertBanner(BannerWithModerationInfo moderationInfo, long version) {
        InBannerModerationRequest request = new InBannerModerationRequest();

        request.setService(ModerationServiceNames.DIRECT_SERVICE);
        request.setType(IN_BANNER);

        BannerModerationMeta meta = createMetaFromBanner(moderationInfo);
        meta.setVersionId(version);

        InBannerRequestData data = new InBannerRequestData();

        data.setDomain(moderationInfo.getDomain());
        data.setCreativeId(moderationInfo.getCreativeId());
        data.setHref(moderationInfo.getHref());
        data.setPreviewUrl(moderationInfo.getCreativePreviewUrl());
        data.setGeo(StreamEx.of(getGeoTree().getModerationCountries(moderationInfo.getGeo())).joining(","));
        data.setWidth(moderationInfo.getWidth());
        data.setHeight(moderationInfo.getHeight());

        //todo copy moderationInfo (?)
        data.setModerationInfo(moderationInfo.getModerateInfo());

        request.setMeta(meta);
        request.setData(data);

        return request;
    }

    @Override
    protected ModerationWorkflow getWorkflow(BannerWithModerationInfo moderationInfo) {
        if (moderationInfo.getBidReModerate() != null) {
            return MANUAL;
        } else if (moderationInfo.getBidAutoModerate() != null) {
            return AUTO_ACCEPT;
        } else {
            return COMMON;
        }
    }

    private GeoTree getGeoTree() {
        // При отправке в модерацию баннеров всех типов нужно использовать российское гео дерево (DIRECTSUP-33318)
        return geoTreeFactory.getRussianGeoTree();
    }
}
