package ru.yandex.direct.core.entity.moderation.service.sending;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.McBannerModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.core.entity.turbolanding.repository.TurboLandingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.regions.GeoTreeFactory;

@ModerationSender
public class McBannerSender extends AbstractAdImageBannerSender {

    private static final Logger logger = LoggerFactory.getLogger(McBannerSender.class);

    public McBannerSender(DslContextProvider dslContextProvider,
                          McBannerModerationRepository moderationSendingRepository,
                          RemoderationFlagsRepository remoderationFlagsRepository,
                          CampaignRepository campaignRepository, GeoTreeFactory geoTreeFactory,
                          HrefParameterizingService hrefParameterizingService,
                          TurboLandingRepository turboLandingRepository, FeatureService featureService,
                          BusinessUnitModerationRepository businessUnitModerationRepository,
                          ModerationFlagsConverter moderationFlagsConverter,
                          ModerationOperationModeProvider moderationOperationModeProvider) {
        super(dslContextProvider, moderationSendingRepository, remoderationFlagsRepository, campaignRepository,
                geoTreeFactory, hrefParameterizingService, turboLandingRepository, featureService,
                businessUnitModerationRepository, moderationFlagsConverter, moderationOperationModeProvider);
    }

    @Override
    public String typeName() {
        return "mcbanner";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
