package ru.yandex.direct.core.entity.moderation.service.sending;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.banner.model.BannerWithAdImageModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.ad_image.AdImageBannerModerationRequest;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.MobileAdImageBannerModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.MobileAppModerationDataBuilder;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.core.entity.turbolanding.repository.TurboLandingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.regions.GeoTreeFactory;

@ModerationSender
public class MobileAdImageBannerSender extends AbstractAdImageBannerSender {

    private static final Logger logger = LoggerFactory.getLogger(MobileAdImageBannerSender.class);

    public MobileAdImageBannerSender(DslContextProvider dslContextProvider,
                                     MobileAdImageBannerModerationRepository moderationSendingRepository,
                                     RemoderationFlagsRepository remoderationFlagsRepository,
                                     CampaignRepository campaignRepository, GeoTreeFactory geoTreeFactory,
                                     HrefParameterizingService hrefParameterizingService,
                                     TurboLandingRepository turboLandingRepository, FeatureService featureService,
                                     BusinessUnitModerationRepository businessUnitModerationRepository,
                                     ModerationFlagsConverter moderationFlagsConverter,
                                     ModerationOperationModeProvider moderationOperationModeProvider) {
        super(dslContextProvider, moderationSendingRepository, remoderationFlagsRepository, campaignRepository,
                geoTreeFactory, hrefParameterizingService, turboLandingRepository, featureService,
                businessUnitModerationRepository, moderationFlagsConverter, moderationOperationModeProvider);
    }

    @Override
    public String typeName() {
        return "mobile_adimage_banner";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected AdImageBannerModerationRequest convertBanner(BannerWithAdImageModerationInfo moderationInfo,
                                                           long version) {
        AdImageBannerModerationRequest request = super.convertBanner(moderationInfo, version);
        request.getData().setMobileContentModerationData(
                MobileAppModerationDataBuilder.buildMobileAppModerationData(moderationInfo));
        return request;
    }
}
