package ru.yandex.direct.core.entity.moderation.service.sending;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.banner.model.BannerWithTextAndImageModerationInfo;
import ru.yandex.direct.core.entity.banner.repository.BannerRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.text.TextBannerModerationRequest;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.MobileContentBannerModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.core.entity.turbolanding.repository.TurboLandingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.regions.GeoTreeFactory;

import static ru.yandex.direct.core.entity.moderation.repository.sending.MobileAppModerationDataBuilder.buildMobileAppModerationData;

@ModerationSender
public class MobileContentBannerSender extends TextBannerSender {

    private static final Logger logger = LoggerFactory.getLogger(MobileContentBannerSender.class);

    public MobileContentBannerSender(DslContextProvider dslContextProvider,
                                     MobileContentBannerModerationRepository moderationSendingRepository,
                                     RemoderationFlagsRepository remoderationFlagsRepository,
                                     CampaignRepository campaignRepository,
                                     HrefParameterizingService hrefParameterizingService,
                                     FeatureService featureService,
                                     BusinessUnitModerationRepository businessUnitModerationRepository,
                                     GeoTreeFactory geoTreeFactory, BannerRepository bannerRepository,
                                     TurboLandingRepository turboLandingRepository,
                                     ModerationOperationModeProvider moderationOperationModeProvider,
                                     ModerationFlagsConverter moderationFlagsConverter) {
        super(dslContextProvider, moderationSendingRepository, remoderationFlagsRepository, campaignRepository,
                hrefParameterizingService, featureService, businessUnitModerationRepository, geoTreeFactory,
                bannerRepository, turboLandingRepository, moderationOperationModeProvider, moderationFlagsConverter);
    }

    @Override
    public String typeName() {
        return "mobile_content_banner";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected ModerationObjectType getModerationObjectType() {
        return ModerationObjectType.MOBILE_CONTENT;
    }

    @Override
    protected TextBannerModerationRequest convertBanner(BannerWithTextAndImageModerationInfo moderationInfo,
                                                        long version) {
        TextBannerModerationRequest request = super.convertBanner(moderationInfo, version);
        request.getData().setMobileContentModerationData(buildMobileAppModerationData(moderationInfo));
        return request;
    }
}
