package ru.yandex.direct.core.entity.moderation.service.sending;

import java.util.Collection;

import org.jooq.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.mobilecontent.model.ContentType;
import ru.yandex.direct.core.entity.mobilecontent.model.MobileContentAvatarSize;
import ru.yandex.direct.core.entity.mobilecontent.model.MobileContentWithModerationInfo;
import ru.yandex.direct.core.entity.mobilecontent.model.OsType;
import ru.yandex.direct.core.entity.mobilecontent.service.MobileContentService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.ModerationWorkflow;
import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationData;
import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationRequest;
import ru.yandex.direct.core.entity.moderation.repository.sending.MobileContentIconSendingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.core.entity.campaign.converter.MobileContentInfoConverter.AVATARS_MDS_HOST;
import static ru.yandex.direct.core.entity.moderation.ModerationOperationMode.RESTRICTED;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.MOBILE_CONTENT_ICON;
import static ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames.DIRECT_SERVICE;

@ModerationSender
public class MobileContentIconSender extends ModerationSendingService<Long, MobileContentIconModerationRequest,
        MobileContentWithModerationInfo> {

    private static final Logger logger = LoggerFactory.getLogger(MobileContentIconSender.class);

    public final static long INITIAL_VERSION = 10L;

    private final MobileContentService mobileContentService;
    private final ModerationOperationModeProvider moderationOperationModeProvider;

    public MobileContentIconSender(DslContextProvider dslContextProvider,
                                   MobileContentIconSendingRepository mobileContentIconSendingRepository,
                                   MobileContentService mobileContentService,
                                   ModerationOperationModeProvider moderationOperationModeProvider) {
        super(dslContextProvider, mobileContentIconSendingRepository);

        this.mobileContentService = mobileContentService;
        this.moderationOperationModeProvider = moderationOperationModeProvider;
    }

    @Override
    public String typeName() {
        return "mobile_content_icon";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected MobileContentIconModerationRequest convert(MobileContentWithModerationInfo moderationInfo,
                                                         long version) {
        MobileContentIconModerationMeta meta = new MobileContentIconModerationMeta();
        meta.setMobileContentId(moderationInfo.getId());
        meta.setClientId(moderationInfo.getClientId());
        meta.setUid(moderationInfo.getUid());
        meta.setVersionId(version);

        MobileContentIconModerationData data = new MobileContentIconModerationData();
        data.setContentType(ContentType.toSource(moderationInfo.getContentType()));
        data.setName(moderationInfo.getName());
        data.setOsType(OsType.toSource(moderationInfo.getOsType()));
        data.setStoreAppId(moderationInfo.getStoreContentId());
        data.setStoreCountry(moderationInfo.getStoreCountry());
        data.setStoreName(mobileContentService.getStoreName(moderationInfo.getOsType()));

        if (moderationInfo.getIconHash() != null) {
            data.setIconUrl(mobileContentService.generateUrlString(AVATARS_MDS_HOST, moderationInfo.getOsType(),
                    moderationInfo.getIconHash(), MobileContentAvatarSize.ICON_XLD));
        }

        MobileContentIconModerationRequest request = new MobileContentIconModerationRequest();
        request.setService(DIRECT_SERVICE);
        request.setType(MOBILE_CONTENT_ICON);
        request.setWorkflow(ModerationWorkflow.COMMON);
        request.setMeta(meta);
        request.setData(data);

        return request;
    }

    @Override
    protected void postProcess(Configuration configuration, Collection<MobileContentWithModerationInfo> objects) {
        if (moderationOperationModeProvider.getMode(MOBILE_CONTENT_ICON).equals(RESTRICTED)) {
            return;
        }
        // В будущем здесь может появиться какая-то логика
    }

    @Override
    protected long getVersion(MobileContentWithModerationInfo object) {
        if (object.getVersion() != null) {
            return Math.max(INITIAL_VERSION, object.getVersion() + 1);
        } else {
            return INITIAL_VERSION;
        }
    }
}
