package ru.yandex.direct.core.entity.moderation.service.sending;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.cpm.video.CpmVideoBannerModerationRequest;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.MobileCpcVideoBannerModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.regions.GeoTreeFactory;

import static ru.yandex.direct.core.entity.moderation.repository.sending.MobileAppModerationDataBuilder.buildMobileAppModerationData;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.CPC_VIDEO;

@ModerationSender
public class MobileCpcVideoBannerSender extends BaseCpmVideoBannerSender {
    private static final Logger logger = LoggerFactory.getLogger(MobileCpcVideoBannerSender.class);

    @Autowired
    public MobileCpcVideoBannerSender(DslContextProvider dslContextProvider,
                                      MobileCpcVideoBannerModerationRepository moderationSendingRepository,
                                      GeoTreeFactory geoTreeFactory,
                                      RemoderationFlagsRepository remoderationFlagsRepository,
                                      CampaignRepository campaignRepository,
                                      HrefParameterizingService hrefParameterizingService,
                                      FeatureService featureService,
                                      BusinessUnitModerationRepository businessUnitModerationRepository,
                                      ModerationFlagsConverter moderationFlagsConverter,
                                      ModerationOperationModeProvider moderationOperationModeProvider) {
        super(dslContextProvider, moderationSendingRepository, geoTreeFactory, remoderationFlagsRepository,
                campaignRepository,
                hrefParameterizingService, featureService, businessUnitModerationRepository,
                moderationFlagsConverter, moderationOperationModeProvider);
    }

    @Override
    public String typeName() {
        return "mobile_cpc_video_banner";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected ModerationObjectType getModerationObjectType() {
        return CPC_VIDEO;
    }

    @Override
    protected CpmVideoBannerModerationRequest convertBanner(BannerWithModerationInfo moderationInfo, long version) {
        CpmVideoBannerModerationRequest request = super.convertBanner(moderationInfo, version);
        request.getData().setMobileContentModerationData(buildMobileAppModerationData(moderationInfo));
        return request;
    }
}
