package ru.yandex.direct.core.entity.moderation.service.sending;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.html5.Html5BannerModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.mobile_content.MobileAppModerationData;
import ru.yandex.direct.core.entity.moderation.repository.sending.BusinessUnitModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.MobileHtml5BannerModerationRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.service.sending.banner.ModerationFlagsConverter;
import ru.yandex.direct.core.entity.moderation.service.sending.hrefs.parameterizer.HrefParameterizingService;
import ru.yandex.direct.core.entity.turbolanding.repository.TurboLandingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.regions.GeoTreeFactory;

@ModerationSender
@ParametersAreNonnullByDefault
public class MobileHtml5BannerSender extends Html5BannerSender {
    @Autowired
    public MobileHtml5BannerSender(DslContextProvider dslContextProvider,
                                MobileHtml5BannerModerationRepository mobileHtml5BannerModerationRepository,
                                GeoTreeFactory geoTreeFactory,
                                RemoderationFlagsRepository remoderationFlagsRepository,
                                CampaignRepository campaignRepository,
                                HrefParameterizingService hrefParameterizingService,
                                TurboLandingRepository turboLandingRepository,
                                ModerationOperationModeProvider moderationOperationModeProvider,
                                FeatureService featureService,
                                BusinessUnitModerationRepository businessUnitModerationRepository,
                                ModerationFlagsConverter moderationFlagsConverter) {
        super(dslContextProvider, mobileHtml5BannerModerationRepository, geoTreeFactory, remoderationFlagsRepository,
                campaignRepository, hrefParameterizingService, turboLandingRepository,
                moderationOperationModeProvider, featureService, businessUnitModerationRepository,
                moderationFlagsConverter);
    }

    @Override
    public String typeName() {
        return "mobile_html5_banner";
    }

    @Override
    protected Html5BannerModerationRequest convertBanner(BannerWithModerationInfo moderationInfo,
                                                         long version) {
        Html5BannerModerationRequest request = super.convertBanner(moderationInfo, version);
        request.getData().setMobileContentModerationData(buildMobileAppModerationData(moderationInfo));
        return request;
    }

    private MobileAppModerationData buildMobileAppModerationData(BannerWithModerationInfo moderationInfo) {
        var mobileAppModerationData = new MobileAppModerationData();
        mobileAppModerationData.setMobileContentId(moderationInfo.getMobileContentId());
        mobileAppModerationData.setAppHref(moderationInfo.getAppHref());
        mobileAppModerationData.setStoreContentId(moderationInfo.getStoreContentId());
        mobileAppModerationData.setBundleId(moderationInfo.getBundleId());
        return mobileAppModerationData;
    }
}

