package ru.yandex.direct.core.entity.moderation.service.sending;

import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.sending.adgroup.AdGroupSender;
import ru.yandex.direct.core.entity.moderation.service.sending.bannerstorage.BannerstorageCreativesSender;

public final class ObjectTypeInitialVersionUtil {
    public static long getInitialVersion(ModerationObjectType objectType) {
        switch (objectType) {
            case AUDIO_CREATIVE:
            case GEO_PIN_CREATIVE:
            case YNDX_FRONTPAGE_CREATIVE:
            case FIXCPM_YNDX_FRONTPAGE_CREATIVE:
            case CONTENT_PROMOTION_VIDEO:
            case CONTENT_PROMOTION_COLLECTION:
            case CONTENT_PROMOTION_SERVICE:
            case INTERNAL_BANNER:
                return BaseBannerSender.DEFAULT_INITIAL_VERSION;
            case IN_BANNER:
                return InBannerSender.INITIAL_VERSION;
            case CPM_VIDEO:
            case CPC_VIDEO:
                return BaseCpmVideoBannerSender.INITIAL_VERSION;
            case TURBOLANDINGS:
                return TurbolandingSender.VERSION_OFFSET;
            case DISPLAYHREFS:
                return DisplayHrefsSender.VERSION_OFFSET;
            case SITELINKS_SET:
                return SitelinksSender.VERSION_OFFSET;
            case IMAGES:
                return ImageSender.VERSION_OFFSET;
            case BANNER_LOGOS:
                return BannerLogoSender.VERSION_OFFSET;
            case BANNER_BUTTONS:
                return BannerButtonSender.VERSION_OFFSET;
            case BANNER_VCARD:
                return BannerVcardSender.INITIAL_VERSION;
            case BANNER_VIDEO_ADDITION:
                return BannerVideoAdditionSender.INITIAL_VERSION;
            case BANNER_MULTICARD:
                return BannerMulticardSender.initialVersion;
            case AD_IMAGE:
                return AbstractAdImageBannerSender.INITIAL_VERSION;
            case CANVAS:
                return CanvasBannerSender.INITIAL_VERSION;
            case HTML5:
                return Html5BannerSender.INITIAL_VERSION;
            case BANNERSTORAGE_CREATIVES:
                return BannerstorageCreativesSender.INITIAL_VERSION;
            case TEXT_AD:
            case MOBILE_CONTENT:
            case DYNAMIC:
                return TextBannerSender.INITIAL_VERSION;
            case CALLOUT:
                return CalloutSender.INITIAL_VERSION;
            case PROMO_EXTENSION:
                return PromoExtensionSender.initialVersion;
            case ADGROUP:
                return AdGroupSender.INITIAL_VERSION;
            case MOBILE_CONTENT_ICON:
                return MobileContentIconSender.INITIAL_VERSION;
            case CAMPAIGN:
                return CampaignSender.INITIAL_VERSION;
        }
        return 1;
    }
}
