package ru.yandex.direct.core.entity.moderation.service.sending;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.model.ClientFlags;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.turbolandings.TurbolandingModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.turbolandings.TurbolandingModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.turbolandings.TurbolandingRequestData;
import ru.yandex.direct.core.entity.moderation.repository.sending.TurbolandingsSendingRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.AutoAcceptanceType;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationFlagsRepository;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLandingWithModerationInfo;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.TURBOLANDINGS;

@ModerationSender
public class TurbolandingSender
        extends BaseAssetSender<Long, TurbolandingModerationRequest, TurboLandingWithModerationInfo> {
    private static final Logger logger = LoggerFactory.getLogger(TurbolandingSender.class);

    public final static long VERSION_OFFSET = 1600L;

    @Autowired
    public TurbolandingSender(DslContextProvider dslContextProvider,
                              TurbolandingsSendingRepository turbolandingsSendingRepository,
                              ModerationOperationModeProvider moderationOperationModeProvider,
                              RemoderationFlagsRepository remoderationFlagsRepository,
                              CampaignRepository campaignRepository) {
        super(dslContextProvider, turbolandingsSendingRepository, moderationOperationModeProvider,
                remoderationFlagsRepository, campaignRepository,
                RemoderationType.TURBOLANDING, AutoAcceptanceType.TURBOLANDING);
    }

    @Override
    public String typeName() {
        return "turbolandings";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected TurbolandingModerationRequest convert(TurboLandingWithModerationInfo moderationInfo,
                                                    long version) {
        TurbolandingModerationRequest request = new TurbolandingModerationRequest();
        request.setService(ModerationServiceNames.DIRECT_SERVICE);
        request.setType(TURBOLANDINGS);

        TurbolandingModerationMeta turbolandingModerationMeta = new TurbolandingModerationMeta();
        turbolandingModerationMeta.setUid(moderationInfo.getUid());
        turbolandingModerationMeta.setTlId(moderationInfo.getId());
        turbolandingModerationMeta.setVersionId(version);
        turbolandingModerationMeta.setClientId(moderationInfo.getClientId());
        turbolandingModerationMeta.setCampaignId(moderationInfo.getCampaignId());
        turbolandingModerationMeta.setBannerId(moderationInfo.getBid());
        turbolandingModerationMeta.setAdGroupId(moderationInfo.getAdGroupId());

        TurbolandingRequestData turbolandingRequestData = new TurbolandingRequestData();
        turbolandingRequestData.setHref(moderationInfo.getUrl());

        if (moderationInfo.getClientFlags().contains(ClientFlags.AS_SOON_AS_POSSIBLE.getTypedValue())) {
            turbolandingRequestData.setAsSoonAsPossible(true);
        }

        request.setMeta(turbolandingModerationMeta);
        request.setData(turbolandingRequestData);

        return request;
    }

    @Override
    protected long getVersion(TurboLandingWithModerationInfo object) {
        if (object.getVersion() != null) {
            return object.getVersion() + 1;
        } else {
            return VERSION_OFFSET;
        }
    }
}
