package ru.yandex.direct.core.entity.moderation.service.sending.banner;

import java.util.Map;
import java.util.Optional;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.modadvert.bigmod.protos.interfaces.MarkupFlags;

@Component
public class ModerationFlagsAliases {

    /**
     * Некоторые флаги в Директе имеют значения, отличные от значений в Модерации.
     * Например, в Директе age:18, а в Модерации age:age18.
     * <p>
     * Эта мапа содержит подобные алиасы в таком виде:
     * flag name -> value alias -> value
     */
    private final Map<String, Map<String, String>> valueAliasesMap;

    @Autowired
    public ModerationFlagsAliases() {
        valueAliasesMap = buildValueAliasesMap();
    }

    public String getActualValueByAlias(String flagName, String valueAlias) {
        return Optional.ofNullable(valueAliasesMap.get(flagName))
                .map(aliasToValueMap -> aliasToValueMap.get(valueAlias))
                .orElse(null);
    }

    private Map<String, Map<String, String>> buildValueAliasesMap() {
        ImmutableMap.Builder<String, Map<String, String>> mapBuilder = ImmutableMap.builder();
        mapBuilder.put(getFlagName(MarkupFlags.EMarkupFlag.AGE0), buildAgeValueAliasesMap());
        mapBuilder.put(getFlagName(MarkupFlags.EMarkupFlag.BABY_FOOD0), buildBabyFoodValueAliasesMap());
        return mapBuilder.build();
    }

    private Map<String, String> buildAgeValueAliasesMap() {
        ImmutableMap.Builder<String, String> ageMapBuilder = ImmutableMap.builder();

        ageMapBuilder.put("0", getFlagValue(MarkupFlags.EMarkupFlag.AGE0));
        ageMapBuilder.put("6", getFlagValue(MarkupFlags.EMarkupFlag.AGE6));
        ageMapBuilder.put("12", getFlagValue(MarkupFlags.EMarkupFlag.AGE12));
        ageMapBuilder.put("16", getFlagValue(MarkupFlags.EMarkupFlag.AGE16));
        ageMapBuilder.put("18", getFlagValue(MarkupFlags.EMarkupFlag.AGE18));

        return ageMapBuilder.build();
    }

    private Map<String, String> buildBabyFoodValueAliasesMap() {
        ImmutableMap.Builder<String, String> babyFoodMapBuilder = ImmutableMap.builder();

        babyFoodMapBuilder.put("0", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD0));
        babyFoodMapBuilder.put("1", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD1));
        babyFoodMapBuilder.put("2", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD2));
        babyFoodMapBuilder.put("3", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD3));
        babyFoodMapBuilder.put("4", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD4));
        babyFoodMapBuilder.put("5", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD5));
        babyFoodMapBuilder.put("6", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD6));
        babyFoodMapBuilder.put("7", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD7));
        babyFoodMapBuilder.put("8", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD8));
        babyFoodMapBuilder.put("9", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD9));
        babyFoodMapBuilder.put("10", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD10));
        babyFoodMapBuilder.put("11", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD11));
        babyFoodMapBuilder.put("12", getFlagValue(MarkupFlags.EMarkupFlag.BABY_FOOD12));

        return babyFoodMapBuilder.build();
    }

    private String getFlagName(MarkupFlags.EMarkupFlag flag) {
        return flag.getValueDescriptor().getOptions()
                .getExtension(MarkupFlags.flagProperties).getName();
    }

    private String getFlagValue(MarkupFlags.EMarkupFlag flag) {
        return flag.getValueDescriptor().getOptions()
                .getExtension(MarkupFlags.flagProperties).getValue();
    }
}
