package ru.yandex.direct.core.entity.moderation.service.sending.bannerstorage;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.bannerstorage.client.model.Creative;
import ru.yandex.direct.bannerstorage.client.model.File;
import ru.yandex.direct.bannerstorage.client.model.Template;

/**
 * Список креативов и данных, полученных из bannerstorage, подготовленных для отправки в Модерацию.
 */
public class PreparedCreatives {
    private final List<Creative> creatives;
    private final Map<Integer, Template> templatesMap;
    private final Map<Integer, File> filesMap;
    private final Map<Long, ru.yandex.direct.core.entity.creative.model.Creative> perfCreativesMap;

    public PreparedCreatives(List<Creative> creatives,
                             Map<Integer, Template> templatesMap,
                             Map<Integer, File> filesMap,
                             Map<Long, ru.yandex.direct.core.entity.creative.model.Creative> perfCreativesMap) {
        this.creatives = creatives;
        this.templatesMap = templatesMap;
        this.filesMap = filesMap;
        this.perfCreativesMap = perfCreativesMap;
    }

    public List<Creative> getCreatives() {
        return creatives;
    }

    public Map<Integer, Template> getTemplatesMap() {
        return templatesMap;
    }

    public Map<Integer, File> getFilesMap() {
        return filesMap;
    }

    public Map<Long, ru.yandex.direct.core.entity.creative.model.Creative> getPerfCreativesMap() {
        return perfCreativesMap;
    }
}
